import java.util.*;

/*
 * SearchPatterns
 *
 * Abstract class which will define the classes which will perform our searches.
 * We'll set the constructor to take and store an int[], that way we simply
 * call the super constructor to store the array under the variable 'input'
*/
abstract class SearchPatterns
{
	// Our data
	protected int[] input;
	
	// Constructor method which will store our data in a global variable
	public SearchPatterns(int[] rawInput)
	{
		input = rawInput;
	}
	
	// Abstract method to perform the search
	abstract int find(int searchNumber);
}


/*
 * IterativeSearch
 *
 * This class will take our raw input, and iterate through every number, 
 * checking to see if it matches our searchNumber.  The number of matches
 * will be returned by the search
*/
class IterativeSearch extends SearchPatterns
{
	
	/*
	 * Overloaded constructor.  This will store the variable through the 
	 * constructor method defined in our abstract class
	*/
	public IterativeSearch(int[] rawInput)
	{
		super(rawInput);
	}
	
	
	/*
	 * This will seach for a number in the data, and return the number of matches
	 * it finds
	*/
	public int find(int searchNumber)
	{
		int matches = 0;
		for (int i : input) 
		{
			if (i == searchNumber)
			{
				matches++;
			}
		}
		
		return matches;
	}
	
}


/*
 * SortedSearch
 *
 * This class will take our raw input, and sorts the array.  We will then loop
 * through every number in that array, and stop if we hit a number larger than
 * the number we're searching for
*/
class SortedSearch extends SearchPatterns
{
	
	/*
	 * Overloaded constructor.  This will store the variable through the 
	 * constructor method defined in our abstract class, then sort it.
	*/
	public SortedSearch(int[] rawInput)
	{
		super(rawInput);
		Arrays.sort(this.input);
	}
	
	
	/*
	 * This will seach for a number in the data, and return the number of matches
	 * it finds
	*/
	public int find(int searchNumber)
	{
		int matches = 0;
		for (int i : input) 
		{
			if (i == searchNumber)
			{
				matches++;
			}
			// If we hit a number larger than the search value, then we're done
			else if (i > searchNumber)
			{
				break;
			}
		}
		
		return matches;
	}
	
}